// Para6.cpp : implementation file
//

#include "stdafx.h"
#include "3D Printer.h"
//#include "Para6.h"

#include "3D PrinterDlg.h"

#include "typedef.h"
#include "Delay.h"
#include "Command.h"
#include <math.h>
#include "usbprint.h"
static CPara6* pDlg=NULL;
extern unsigned char CheckDevice(void);
extern volatile   BOOL UsbConnect;
extern double Hour;
extern volatile BOOL bDeviceChange;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPara6 dialog


CPara6::CPara6(CWnd* pParent /*=NULL*/)
	: CDialog(CPara6::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPara6)
	m_check_x = FALSE;
	m_check_y = FALSE;
	//}}AFX_DATA_INIT
}


void CPara6::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPara6)
	DDX_Control(pDX, IDC_DEVICE_INDEX, m_DeviceIndex);
	DDX_Check(pDX, IDC_CHECK_X, m_check_x);
	DDX_Check(pDX, IDC_CHECK_Y, m_check_y);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPara6, CDialog)
	//{{AFX_MSG_MAP(CPara6)
	ON_BN_CLICKED(IDC_FLIP_DO, OnFlipDo)
	ON_BN_CLICKED(IDC_CHECK_X, OnCheckX)
	ON_BN_CLICKED(IDC_CHECK_Y, OnCheckY)
	ON_WM_CLOSE()
	ON_CBN_SELCHANGE(IDC_DEVICE_INDEX, OnSelchangeDeviceIndex)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPara6 message handlers
static BOOL f_first=TRUE;
BOOL CPara6::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CString DevIndex;
	//unsigned int i;
	pDlg=this;
	_CWndCS(this);
	// TODO: Add extra initialization here
	if(f_first)
    {
		/*
		m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
			DevIndex.Format(" %d ",i);
			m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_DeviceIndex.AddString(" XXX ");
		m_DeviceIndex.SetCurSel(0);
		*/
		f_first=FALSE;
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


BOOL CPara6::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_ESCAPE) 
		return TRUE; 
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN) 
		return TRUE;
	return CDialog::PreTranslateMessage(pMsg);
}

UINT WINAPI Flip_Thread(LPVOID pParam)
{
	HWND   hwndCheckX=GetDlgItem(pDlg->GetSafeHwnd(),IDC_CHECK_X);
	HWND   hwndCheckY=GetDlgItem(pDlg->GetSafeHwnd(),IDC_CHECK_Y);
	HWND   hwndCheckFlip=GetDlgItem(pDlg->GetSafeHwnd(),IDC_FLIP_DO);

    EnableWindow(hwndCheckX,FALSE);
	EnableWindow(hwndCheckY,FALSE);
	EnableWindow(hwndCheckFlip,FALSE);
	Sleep(5000);
	EnableWindow(hwndCheckX,TRUE);
	EnableWindow(hwndCheckY,TRUE);
	EnableWindow(hwndCheckFlip,TRUE);
	return 1;
}

void CPara6::OnFlipDo() 
{
	// TODO: Add your control notification handler code here
	unsigned char buffer[2];
    
	if(CheckDevice()!=1)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return;
	}

	if(m_check_x)
		buffer[0]=1;
	else
		buffer[0]=0;

	if(m_check_y)
		buffer[1]=1;
	else
		buffer[1]=0;

	if(Flip(buffer[0],buffer[1])==FALSE)
	{
		MessageBox(_CS("WarningUart.CommunicationFail"),_CS("WarningUart.Title"),MB_OK);
		return;
	}
	//AfxBeginThread((AFX_THREADPROC)Flip_Thread,NULL);
}

void CPara6::OnCheckX() 
{
	// TODO: Add your control notification handler code here
	CButton  *pButton=(CButton *)GetDlgItem(IDC_CHECK_X);
	m_check_x=pButton->GetCheck();
}

void CPara6::OnCheckY() 
{
	// TODO: Add your control notification handler code here
	CButton  *pButton=(CButton *)GetDlgItem(IDC_CHECK_Y);
	m_check_y=pButton->GetCheck();
}

void CPara6::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnClose();
}

void CPara6::OnSelchangeDeviceIndex() 
{
	// TODO: Add your control notification handler code here
	CMy3DPrinterDlg *p=(CMy3DPrinterDlg *)(AfxGetApp()->m_pMainWnd);
	HWND hwndStatusBar=p->m_StatusBar.GetSafeHwnd();
	HWND hwndLedIndex=p->m_para1.m_LedIndex.GetSafeHwnd();
	U32 UseTime;
	CString StrHour;
	CString StrLedDefaultStatus;
	U8 Value=0,Index;
	CString StrVal;
	//unsigned char flag;
	unsigned char ID[8];
	CString StrTxt;
	if(p->m_para5.IspWorking)
	{
		UpdateData(FALSE);
		return;
	}
	if(bDeviceChange)
		return;
	if(USBDeviceInfo.count==0)
		return;
	UpdateData(TRUE);
	USBDevIndex=m_DeviceIndex.GetCurSel();
	if(CheckUSBOnline()==FALSE)
	{
		StrTxt=" " + _CS("WarningGeneral.DeviceDisconnect");
		::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		StrTxt="SN: XX-XX-XX-XX-XX-XX";
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		UsbConnect=FALSE;
		return;
	}
	StrTxt=" " + _CS("WarningGeneral.DeviceConnect");
	::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
	UsbConnect=TRUE;
	//if(strcmp(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0])==0)
	//	return;
	memset(DeviceName,0,MAX_PATH);
	strcpy(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0]);
	if(CheckDevice()==1)
	{
		if(GetLedDefaultStatus(&Value))
		{
			if(Value)
				StrLedDefaultStatus=_CS("Led.Off");
			else
				StrLedDefaultStatus=_CS("Led.On");
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
		}
		GetProductID(ID);
		StrTxt.Format("SN: %02X-%02X-%02X-%02X-%02X-%02X",ID[0],ID[1],ID[2],ID[3],ID[4],ID[5]);
		::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		//----------------------------------
		Index=(int)::SendMessage(hwndLedIndex, CB_GETCURSEL, 0, 0);
		//Index=m_para1.m_LedIndex.GetCurSel();
		if(GetCurrent(Index,&Value)==FALSE)
			return;	
		if(Value>100)
			return;
		StrVal.Format("%d",Value);
		p->m_para1.m_Slider_Led.SetPos(Value);
		p->m_para1.SliderPos=Value;
		::SetDlgItemText(p->m_para1.GetSafeHwnd(),IDC_EDIT_LED,StrVal);
		if(GetUseTime(&UseTime))
		{
			Hour=UseTime/(3600.0f);
			StrHour.Format("%.1f",Hour);
			::SetDlgItemText(p->m_para5.GetSafeHwnd(),IDC_USE_HOUR,StrHour);
		}
	}
}
